/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.ServerSurface;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class EquipGlassesPacket
extends Packet<EquipGlassesPacket, IMessage> {
    private Location locationUUID;
    private UUID playerUUID;
    private int width;
    private int height;

    public EquipGlassesPacket(Location locationUUID, EntityPlayer player, int width, int height) {
        this.playerUUID = player.func_146103_bH().getId();
        this.locationUUID = locationUUID;
        this.width = width;
        this.height = height;
    }

    public EquipGlassesPacket() {
    }

    @Override
    protected void read() throws IOException {
        this.playerUUID = new UUID(this.readLong(), this.readLong());
        this.locationUUID = new Location(this.readInt(), this.readInt(), this.readInt(), this.readInt(), this.readLong());
        this.width = this.readInt();
        this.height = this.readInt();
    }

    @Override
    protected void write() throws IOException {
        this.writeLong(this.playerUUID.getMostSignificantBits());
        this.writeLong(this.playerUUID.getLeastSignificantBits());
        this.writeInt(this.locationUUID.x);
        this.writeInt(this.locationUUID.y);
        this.writeInt(this.locationUUID.z);
        this.writeInt(this.locationUUID.dimID);
        this.writeLong(this.locationUUID.uniqueKey);
        this.writeInt(this.width);
        this.writeInt(this.height);
    }

    @Override
    protected IMessage executeOnClient() {
        return null;
    }

    @Override
    protected IMessage executeOnServer() {
        ServerSurface.instance.subscribePlayer(this.playerUUID, this.locationUUID, this.width, this.height);
        return null;
    }
}

